/****** Object:  StoredProcedure [dbo].[sp_UpdateStrataState]    Script Date: 11/22/2009 14:00:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_UpdateStrataState]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_UpdateStrataState]
GO



CREATE PROCEDURE [dbo].[sp_UpdateStrataState]
                @projectId INT,
                @userId    INT
AS
  -- Define if quotas are active
  DECLARE @UseQuotas BIT
  SET @UseQuotas = (SELECT TOP 1 insvalue FROM installation WHERE inssection = 'QUOTAS' AND insident = 'QUOTASACTIFS')
  IF @UseQuotas IS NULL SET @UseQuotas = 0

  -- Check if quota tracking by period is enabled
  DECLARE @UseQuotasTrackingByPeriod BIT
  SET @UseQuotasTrackingByPeriod = (SELECT TOP 1 insvalue FROM installation WHERE inssection = 'QUOTAS' AND insident = 'ENABLE_TRACKING_BY_PERIOD')
  IF @UseQuotasTrackingByPeriod IS NULL SET @UseQuotasTrackingByPeriod = 0

-- strata manually set to closed or with frequency >= quota (2=Closed)
UPDATE quota
SET    qtstatus = 2,
       qtstatustemp = 2
WHERE  (qtstatus = 2)
      OR (@UseQuotas = 1
          AND (qtquota > 0)
          AND (qtfrequence >= qtquota) OR
                       ( (@UseQuotasTrackingByPeriod = 1) AND (QuotaForThePeriod > 0) AND (FrequencyForThePeriod >= QuotaForThePeriod) ))


-- strata manually set to half-open and with frequency + online >= quota
UPDATE quota
SET    qtstatustemp = 2
WHERE  (qtstatus = 1)
     AND (qtquota > 0)
     AND ((qtfrequence + qtonline >= qtquota) OR
            ((@UseQuotasTrackingByPeriod = 1) AND (QuotaForThePeriod > 0) AND (FrequencyForThePeriod + QtOnLine >= QuotaForThePeriod)))


-- strata manually set to open and with frequency < quota
-- strata manually set to half-open and with frequency + online < quota
UPDATE quota
SET    qtstatustemp = 0
WHERE  ((qtstatus = 0)
      AND ((qtquota = 0)
            OR (qtfrequence < qtquota)))
      OR ((qtstatus = 1)
          AND ((qtquota = 0)
                OR (qtfrequence + qtonline < qtquota)))


-- Syncronize Quota Status of QuotasAgent
UPDATE QuotasAgent Set QuotaStatus = 2 WHERE Frequency >= Quota AND Quota > 0;

UPDATE QuotasAgent
   SET QuotaStatus = QtStatus
   FROM QuotasAgent 
 INNER JOIN (SELECT QtQuotaId, QtStatus FROM Quota WHERE QtStatus = 2) qt
        on qt.QtQuotaId = QuotasAgent.QuotaId
   WHERE QuotaStatus < 2
GO

